# Front end components for Laravel Media Library 

![run-tests](https://github.com/spatie/laravel-medialibrary-pro/workflows/run-tests/badge.svg)

[Media Library Pro](http://medialibrary.pro) is a paid add-on package that offers Blade, Vue, and React components to upload files to your application.

Media Library Pro ships with two components for every environment: an attachment component, and a collection component.

The attachment component can upload one or more files with little or no extra information. It's is a lightweight solution for small bits of UI like avatar fields or message attachments.

![Screenshot of the attachment component](https://spatie.be/docs/laravel-medialibrary/v9/images/pro/attachment.png)

The collection component can upload multiple files with custom properties. Use the collection component shines when you need to manage media, for example in admin panels.

![Screenshot of the attachment component](https://spatie.be/docs/laravel-medialibrary/v9/images/pro/collection.png)

## Documentation

You'll find the documentation on [our documentation site](https://spatie.be/docs/laravel-medialibrary/v9/handling-uploads-with-media-library-pro/introduction).

If you've found a bug regarding security please mail [freek@spatie.be](mailto:freek@spatie.be) instead of using the issue tracker.

## Testing

You can run the tests with:

```bash
vendor/bin/phpunit
```

### Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information what has changed recently.

## Security

If you discover any security related issues, please email [freek@spatie.be](mailto:freek@spatie.be) instead of using the issue tracker.
